//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the timer starts and the counter value is the same as T00REG, the TC00 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{
    WDCDR.byte = 0x4e;		//clear wdt   
    P9CR.bit.b0	=1;			//set P90 output
 	__asm("DI");	
	POFFCR0.byte=0x10; 		//enable TC00 and TC01 
	EIRH.bit.b4=1; 			//enable TC00 interrupt
	__asm("EI");
	T00MOD.byte=0xF8;		//<DBE0>=1,<TCK0>=111,<EIN0>=0,<TCM0>=0 8-bit timer mode
	T00REG.byte=0x5; 		//set timer value
	T001CR.bit.b0=1; 		//start TC00   
    while(1)
	{
		WDCDR.byte= 0x4e;	//clear wdt
	}  
    
}